% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family_check.R
\name{family_check}
\alias{family_check}
\alias{family_check,character_OR_integer-method}
\alias{family_check,Pedigree-method}
\alias{family_check,Ped-method}
\title{Check family}
\usage{
\S4method{family_check}{character_OR_integer}(obj, dadid, momid, famid, newfam)

\S4method{family_check}{Pedigree}(obj)

\S4method{family_check}{Ped}(obj)
}
\arguments{
\item{obj}{A character vector with the id of the individuals or a
\code{data.frame} with all the informations in corresponding columns.}

\item{dadid}{A vector containing for each subject, the identifiers of the
biologicals fathers.}

\item{momid}{A vector containing for each subject, the identifiers of the
biologicals mothers.}

\item{famid}{A character vector with the family identifiers of the
individuals. If provide, will be aggregated to the individuals
identifiers separated by an underscore.}

\item{newfam}{The result of a call to \code{make_famid()}. If this has already
been computed by the user, adding it as an argument shortens the running
time somewhat.}
}
\value{
a data frame with one row for each unique family id in the
\code{famid} argument or the one detected in the Pedigree object.
Components of the output are:
\itemize{
\item \code{famid} : The family id, as entered into the data set
\item \code{n} : Number of subjects in the family
\item \code{unrelated} : Number of them that appear to be unrelated to
anyone else in the entire Pedigree.  This is usually marry-ins with no
children (in the Pedigree), and if so are not a problem.
\item \code{split} : Number of unique 'new' family ids.
\itemize{
\item \code{0} = no one in this 'family' is related to anyone else (not good)
\item \code{1} = everythings is fine
\item \code{2} and + = the family appears to be a set of disjoint trees.
Are you missing some of the people?
}
\item \code{join} : Number of other families that had a unique
family, but are actually joined to this one.  0 is the hope.
}
}
\description{
Error check for a family classification
}
\details{
Given a family id vector, also compute the familial grouping from first
principles using the parenting data, and compare the results.

The \code{\link[=make_famid]{make_famid()}} function is used to create a
de novo family id from the parentage data,
and this is compared to the family id given in the data.

If there are any joins, then an attribute 'join' is attached.
It will be a matrix with family as row labels, new-family-id as the columns,
and the number of subjects as entries.
}
\examples{

# use 2 samplepeds
data(sampleped)
pedAll <- Pedigree(sampleped)

## check them giving separate ped ids
fcheck.sep <- family_check(pedAll)
fcheck.sep

## check assigning them same ped id
fcheck.combined <- with(sampleped, family_check(id, dadid, momid,
rep(1, nrow(sampleped))))
fcheck.combined

}
\seealso{
\code{\link[=make_famid]{make_famid()}}
}
\keyword{internal}
