% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_hint.R
\name{compute_stress}
\alias{compute_stress}
\title{Compute the stress of a hint}
\usage{
compute_stress(
  obj,
  newhint,
  wt = c(1000, 10, 1),
  align_parents = TRUE,
  force = FALSE
)
}
\arguments{
\item{obj}{A Pedigree object}

\item{newhint}{A Hints object with the new hints}

\item{wt}{A vector of three weights for the three error measures.
Default is \code{c(1000, 10, 1)}.
\enumerate{
\item The number of duplicate individuals in the plot
\item The sum of the absolute values of the differences in the
positions of duplicate individuals
\item The sum of the absolute values of the differences between
the center of the children and the parents.
}}

\item{align_parents}{If \code{align_parents = TRUE}, go one step further
and try to make both parents of each child have the same depth.
(This is not always possible).
It helps the drawing program by lining up pedigrees that
'join in the middle' via a marriage.}

\item{force}{If \code{force = TRUE}, the function will return the depth minus
\code{min(depth)} if \code{depth} reach a state with no founders
is not possible.}
}
\value{
The stress value of the hint
}
\description{
This is a helper function for \code{\link[=best_hint]{best_hint()}}.
It computes the stress of a given hint
by aligning the Pedigree and computing the error measures.
}
\examples{
data(sampleped)
pedi <- Pedigree(sampleped[sampleped$famid == 1,])
newhint <- auto_hint(pedi, align_parents = TRUE)
Pedixplorer:::compute_stress(pedi, newhint)
}
\seealso{
\code{\link[=best_hint]{best_hint()}}, \code{\link[=align]{align()}}
}
\keyword{internal}
