% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_plot_all.R
\name{plot_all_ui}
\alias{plot_all_ui}
\alias{plot_all_server}
\alias{app_plot_all_demo}
\title{Shiny module with all the components to plot a pedigree}
\usage{
plot_all_ui(id)

plot_all_server(
  id,
  pedi,
  ind_max_warning = 100,
  ind_max_error = 500,
  my_title_l = "My Pedigree",
  my_title_s = "ped_1",
  init_width = "100\%",
  precision = 4
)

app_plot_all_demo(ind_max_warning = 10, ind_max_error = 30)
}
\arguments{
\item{id}{A string to identify the module.}

\item{pedi}{A reactive pedigree object.}

\item{ind_max_warning}{An integer to define the maximum number of individuals
to plot before throwing a warning.
If the number of individuals is greater than this value,
the user will be asked to confirm the plot.}

\item{ind_max_error}{An integer to define the maximum number of individuals
to plot before throwing an error.
If the number of individuals is greater than this value,
an error will be thrown and the plot will not be computed.}

\item{my_title_l}{A string to define the title of the plot.}

\item{my_title_s}{A string to define the title of the plot for
the download.}

\item{init_width}{A string to define the initial width of the plot.}

\item{precision}{An integer to define the precision of the plot.}
}
\value{
A reactive list with the plot and the class of the plot.
}
\description{
This module plots a Pedigree object and allows to download
the plot and the data. Different options are available to
customize the plot.
}
\examples{
if (interactive()) {
   app_plot_all_demo()
}
}
\keyword{internal}
