% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R, R/AllConstructor.R,
%   R/AllAccessors.R, R/AllGeneric.R
\docType{class}
\name{Scales-class}
\alias{Scales-class}
\alias{Scales}
\alias{Scales,data.frame,data.frame-method}
\alias{Scales,missing,missing-method}
\alias{fill}
\alias{fill,Scales-method}
\alias{fill<-}
\alias{fill<-,Scales,data.frame-method}
\alias{border}
\alias{border,Scales-method}
\alias{border<-}
\alias{border<-,Scales,data.frame-method}
\alias{as.list,Scales-method}
\title{Scales object}
\usage{
Scales(fill, border)

\S4method{Scales}{data.frame,data.frame}(fill, border)
}
\arguments{
\item{fill}{A data.frame with the informations for the affection status.
The columns needed are:
\itemize{
\item 'order': the order of the affection to be used
\item 'column_values': name of the column containing the raw values in the
Ped object
\item 'column_mods': name of the column containing the mods of the transformed
values in the Ped object
\item 'mods': all the different mods
\item 'labels': the corresponding labels of each mods
\item 'affected': a logical value indicating if the mod
correspond to an affected individuals
\item 'fill': the color to use for this mods
\item 'density': the density of the shading
\item 'angle': the angle of the shading
}}

\item{border}{A data.frame with the informations for the availability
status.
The columns needed are:
\itemize{
\item 'column_values': name of the column containing the raw values in the
Ped object
\item 'column_mods': name of the column containing the mods of the transformed
values in the Ped object
\item 'mods': all the different mods
\item 'labels': the corresponding labels of each mods
\item 'border': the color to use for this mods
}}
}
\value{
A Scales object.
}
\description{
A Scales object is a list of two data.frame.
The first one is used to represent the affection status of the individuals
and therefore the filling of the individuals in the pedigree plot.
The second one is used to represent the availability status of the
individuals and therefore the border color of the individuals in the
pedigree plot.

\subsection{Constructor :}{

You need to provide both \strong{fill} and \strong{border}
in the dedicated parameters.
However this is usually done using the
\code{\link[=generate_colors]{generate_colors()}} function with a
Pedigree object.
}
}
\section{Slots}{

\describe{
\item{\code{fill}}{A data.frame with the informations for the affection status.
The columns needed are:
\itemize{
\item 'order': the order of the affection to be used
\item 'column_values': name of the column containing the raw values in the
Ped object
\item 'column_mods': name of the column containing the mods of the transformed
values in the Ped object
\item 'mods': all the different mods
\item 'labels': the corresponding labels of each mods
\item 'affected': a logical value indicating if the mod
correspond to an affected individuals
\item 'fill': the color to use for this mods
\item 'density': the density of the shading
\item 'angle': the angle of the shading
}}

\item{\code{border}}{A data.frame with the informations for the availability
status.
The columns needed are:
\itemize{
\item 'column_values': name of the column containing the raw values in the
Ped object
\item 'column_mods': name of the column containing the mods of the transformed
values in the Ped object
\item 'mods': all the different mods
\item 'labels': the corresponding labels of each mods
\item 'border': the color to use for this mods
}}
}}

\section{Accessors}{

\itemize{
\item \code{fill(x)} : Get the fill data.frame
}


\itemize{
\item \code{fill(x) <- value} : Set the fill data.frame
}


\itemize{
\item \code{border(x)} : Get the border data.frame
}


\itemize{
\item \code{border(x) <- value} : Set the border data.frame
from the Scales object.
}
}

\section{Generics}{

\itemize{
\item \code{as.list(x)}: Convert a Scales object to a list
}
}

\examples{

Scales(
    fill = data.frame(
        order = 1,
        column_values = "affected",
        column_mods = "affected_mods",
        mods = c(0, 1),
        labels = c("unaffected", "affected"),
        affected = c(FALSE, TRUE),
        fill = c("white", "red"),
        density = c(NA, 20),
        angle = c(NA, 45)
    ),
    border = data.frame(
        column_values = "avail",
        column_mods = "avail_mods",
        mods = c(0, 1),
        labels = c("not available", "available"),
        border = c("black", "blue")
    )
)
}
\seealso{
\code{\link[=Pedigree]{Pedigree()}}

\code{\link[=generate_colors]{generate_colors()}}
}
