% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pedixplorer-package.R
\docType{package}
\name{Pedixplorer-package}
\alias{Pedixplorer}
\alias{Pedixplorer-package}
\title{The Pedixplorer package for pedigree data}
\description{
The Pedixplorer package for pedigree data an updated package of the
\code{kinship2} package.
The \code{kinship2} package was originally
written by Terry Therneau and Jason Sinnwell.
The \code{Pedixplorer} package is a fork of the
\code{kinship2} package with
additional functionality and bug fixes.
}
\details{
The package download, NEWS, and README are available on CRAN:
\href{https://cran.r-project.org/package=kinship2}{Kinship2} for the
previous version of the package.
}
\section{Functions}{

Below are listed some of the most widely used functions available
in arsenal:

\code{\link[=Pedigree]{Pedigree()}}: Contstructor of the Pedigree class,
given identifiers, sex, affection status(es), and special relationships

\code{\link[=kinship]{kinship()}}: Calculates the kinship matrix, the
probability having an allele sampled from two individuals
be the same via IBD.

\code{\link[=plot]{plot()}} : Method to transform a Pedigree
object into a graphical plot.
Allows extra information to be included in the id under the
plot symbol.
This method use the \code{\link[=plot_fromdf]{plot_fromdf()}} function to
transform the Pedigree object into a data frame
of graphical elements, the same is done for the
legend with the \code{\link[=ped_to_legdf]{ped_to_legdf()}} function.
When done, the data frames are plotted with the
\code{\link[=plot_fromdf]{plot_fromdf()}} function.

\code{\link[=shrink]{shrink()}}: Shrink a Pedigree to a specific bit size,
removing non-informative members first.

\code{\link[=bit_size]{bit_size()}}: Approximate the output from SAS's
\verb{PROC FREQ} procedure when using the \verb{/list}
option of the \code{TABLE} statement.
}

\section{Data}{

\itemize{
\item \code{\link[=sampleped]{sampleped()}}: Pedigree example data sets
with two pedigrees
\item \code{\link[=minnbreast]{minnbreast()}}: Larger cohort of pedigrees
from MN breast cancer study
}
}

\examples{
library(Pedixplorer)

}
\seealso{
Useful links:
\itemize{
  \item \url{https://louislenezet.github.io/Pedixplorer/}
  \item Report bugs at \url{https://github.com/LouisLeNezet/Pedixplorer/issues}
}

}
\author{
\strong{Maintainer}: Louis Le Nezet \email{louislenezet@gmail.com} (\href{https://orcid.org/0009-0000-0202-2703}{ORCID}) [contributor]

Authors:
\itemize{
  \item Jason Sinnwell \email{sinnwell.jason@mayo.edu}
  \item Terry Therneau
}

Other contributors:
\itemize{
  \item Daniel Schaid [contributor]
  \item Elizabeth Atkinson [contributor]
}

}
