% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R, R/AllConstructor.R,
%   R/AllAccessors.R, R/AllGeneric.R
\docType{class}
\name{Pedigree-class}
\alias{Pedigree-class}
\alias{Pedigree}
\alias{Pedigree,character_OR_integer-method}
\alias{Pedigree,data.frame-method}
\alias{Pedigree,missing-method}
\alias{ped}
\alias{ped,Pedigree,ANY-method}
\alias{ped,Pedigree,missing-method}
\alias{ped<-}
\alias{ped<-,Pedigree,ANY,ANY-method}
\alias{ped<-,Pedigree,missing,Ped-method}
\alias{mcols,Pedigree-method}
\alias{mcols<-,Pedigree,ANY-method}
\alias{rel}
\alias{rel,Pedigree,ANY-method}
\alias{rel,Pedigree,missing-method}
\alias{rel<-}
\alias{rel<-,Pedigree,ANY,ANY-method}
\alias{rel<-,Pedigree,missing,Rel-method}
\alias{scales}
\alias{scales,Pedigree-method}
\alias{scales<-}
\alias{scales<-,Pedigree,Scales-method}
\alias{fill,Pedigree-method}
\alias{fill<-,Pedigree,data.frame-method}
\alias{border,Pedigree-method}
\alias{border<-,Pedigree,data.frame-method}
\alias{hints}
\alias{hints,Pedigree-method}
\alias{hints<-}
\alias{hints<-,Pedigree,Hints-method}
\alias{horder,Pedigree-method}
\alias{horder<-,Pedigree-method}
\alias{spouse,Pedigree-method}
\alias{spouse<-}
\alias{spouse<-,Pedigree,data.frame-method}
\alias{length,Pedigree-method}
\alias{show,Pedigree-method}
\alias{summary,Pedigree-method}
\alias{as.list,Pedigree-method}
\alias{subset,Pedigree-method}
\alias{[,Pedigree,ANY,missing,ANY-method}
\title{Pedigree object}
\usage{
Pedigree(obj, ...)

\S4method{Pedigree}{character_OR_integer}(
  obj,
  dadid,
  momid,
  sex,
  famid = NA,
  fertility = NULL,
  miscarriage = NULL,
  deceased = NULL,
  avail = NULL,
  evaluated = NULL,
  consultand = NULL,
  proband = NULL,
  affections = NULL,
  carrier = NULL,
  asymptomatic = NULL,
  adopted = NULL,
  dateofbirth = NULL,
  dateofdeath = NULL,
  rel_df = NULL,
  missid = c(NA_character_, "0"),
  col_aff = "affection",
  date_pattern = "\%Y-\%m-\%d",
  normalize = TRUE,
  ...
)

\S4method{Pedigree}{data.frame}(
  obj = data.frame(id = character(), dadid = character(), momid = character(), famid =
    character(), sex = numeric(), fertility = numeric(), miscarriage = numeric(),
    deceased = numeric(), avail = numeric(), evaluated = logical(), consultand =
    logical(), proband = logical(), affection = logical(), carrier = logical(),
    asymptomatic = logical(), adopted = logical(), dateofbirth = character(), dateofdeath
    = character()),
  rel_df = data.frame(id1 = character(), id2 = character(), code = numeric(), famid =
    character()),
  cols_ren_ped = list(id = "indId", dadid = "fatherId", momid = "motherId", famid =
    "family", sex = "gender", fertility = c("sterilisation", "steril"), miscarriage =
    c("miscarriage", "aborted"), deceased = c("status", "dead", "vitalStatus"), avail =
    "available", evaluated = "evaluation", consultand = "consultant", proband =
    "proband", affection = "affected", carrier = "carrier", asymptomatic =
    "presymptomatic", adopted = "adoption", dateofbirth = c("dob", "birth"), dateofdeath
    = c("dod", "death")),
  cols_ren_rel = list(id1 = "indId1", id2 = "indId2", famid = "family"),
  hints = list(horder = NULL, spouse = NULL),
  normalize = TRUE,
  missid = c(NA_character_, "0"),
  col_aff = "affection",
  date_pattern = "\%Y-\%m-\%d",
  na_strings = c("NA", "N/A", "None", "none", "null", "NULL"),
  ...
)
}
\arguments{
\item{obj}{A vector of the individuals identifiers or a data.frame
with the individuals informations.
See \code{\link[=Ped]{Ped()}} for more informations.}

\item{...}{
  Arguments passed on to \code{\link[=generate_colors]{generate_colors}}
  \describe{
    \item{\code{}}{}
  }}

\item{dadid}{A vector containing for each subject, the identifiers of the
biologicals fathers.}

\item{momid}{A vector containing for each subject, the identifiers of the
biologicals mothers.}

\item{sex}{A character, factor or numeric vector corresponding to
the gender of the individuals. This will be transformed to an ordered factor
with the following levels:
\code{male} < \code{female} < \code{unknown}

The following values are recognized:
\itemize{
\item "male": "m", "male", "man", \code{1}
\item "female": "f", "female", "woman", \code{2}
\item "unknown": "unknown", \code{3}
}}

\item{famid}{A character vector with the family identifiers of the
individuals. If provide, will be aggregated to the individuals
identifiers separated by an underscore.}

\item{fertility}{A character, factor or numeric vector corresponding to
the fertility status of the individuals. This will be transformed to a
factor with the following levels:
\code{infertile_choice_na}, \code{infertile}, \code{fertile}

The following values are recognized:
\itemize{
\item "inferile_choice_na" : "infertile_choice", "infertile_na"
\item "infertile" : "infertile", "steril", \code{FALSE}, \code{0}
\item "fertile" : "fertile", \code{TRUE}, \code{1}, \code{NA}
}}

\item{miscarriage}{A character, factor or numeric vector corresponding to
the miscarriage status of the individuals. This will be transformed to a
factor with the following levels:
\code{TOP}, \code{SAB}, \code{ECT}, \code{FALSE}
The following values are recognized:
\itemize{
\item "SAB" : "spontaneous", "spontaenous abortion"
\item "TOP" : "termination", "terminated", "termination of pregnancy"
\item "ECT" : "ectopic", "ectopic pregnancy"
\item FALSE : \code{0}, \code{FALSE}, "no", \code{NA}
}}

\item{deceased}{A logical vector with the death status of the
individuals
(i.e. \code{FALSE} = alive,
\code{TRUE} = dead,
\code{NA} = unknown).}

\item{avail}{A logical vector with the availability status of the
individuals
(i.e. \code{FALSE} = not available,
\code{TRUE} = available,
\code{NA} = unknown).}

\item{evaluated}{A logical vector with the evaluation status of the
individuals.
(i.e. \code{FALSE} = documented evaluation not available,
\code{TRUE} = documented evaluation available).}

\item{consultand}{A logical vector with the consultand status of the
individuals. A consultand being an individual seeking
genetic counseling/testing
(i.e. \code{FALSE} = not a consultand,
\code{TRUE} = consultand).}

\item{proband}{A logical vector with the proband status of the
individuals. A proband being an affected family
member coming to medical attention independent of other
family members.
(i.e. \code{FALSE} = not a proband,
\code{TRUE} = proband).}

\item{affections}{A logical vector with the affections status of the
individuals
(i.e. \code{FALSE} = unaffected, \code{TRUE} = affected, \code{NA} = unknown).
Can also be a data.frame with the same length as \code{obj}. If it is a
matrix, it will be converted to a data.frame and the columns will be
named after the \code{col_aff} argument.}

\item{carrier}{A logical vector with the carrier status of the
individuals. A carrier being an individual who has
the genetic trait but who is not likely to manifest the
disease regardless of inheritance pattern
(i.e. \code{FALSE} = not carrier,
\code{TRUE} = carrier,
\code{NA} = unknown).}

\item{asymptomatic}{A logical vector with the asymptomatic status of
the individuals. An asymptomatic individual being an individual
clinically unaffected at this time but could later exhibit symptoms.
(i.e. \code{FALSE} = not asymptomatic,
\code{TRUE} = asymptomatic,
\code{NA} = unknown).}

\item{adopted}{A logical vector with the adopted status of the
individuals.
(i.e. \code{FALSE} = not adopted,
\code{TRUE} = adopted,
\code{NA} = unknown).}

\item{dateofbirth}{A character vector with the date of birth of the
individuals.}

\item{dateofdeath}{A character vector with the date of death of the
individuals.}

\item{rel_df}{A data.frame with the special relationships between
individuals. See \code{\link[=Rel]{Rel()}} for more informations.
The minimum columns required are \code{id1}, \code{id2} and \code{code}.
The \code{famid} column can also be used to specify the family
of the individuals.
If a matrix is given, the columns needs to be ordered as
\code{id1}, \code{id2}, \code{code} and \code{famid}.
The code values are:
\itemize{
\item \code{1} = Monozygotic twin
\item \code{2} = Dizygotic twin
\item \code{3} = twin of unknown zygosity
\item \code{4} = Spouse
}

The value relation code recognized by the function are the one defined
by the \code{\link[=rel_code_to_factor]{rel_code_to_factor()}} function.}

\item{missid}{A character vector with the missing values identifiers.
All the id, dadid and momid corresponding to those values will be set
to \code{NA_character_}.}

\item{col_aff}{A character vector with the name of the column to be used
for the affection status.}

\item{date_pattern}{The pattern of the date}

\item{normalize}{A logical to know if the data should be normalised.}

\item{cols_ren_ped}{A named list with the columns to rename for the
pedigree dataframe. This is useful if you want to use a dataframe with
different column names. The names of the list should be the new column
names and the values should be the old column names. The default values
are to be used with \code{normalize = TRUE}.}

\item{cols_ren_rel}{A named list with the columns to rename for the
relationship matrix. This is useful if you want to use a dataframe with
different column names. The names of the list should be the new column
names and the values should be the old column names.}

\item{hints}{A Hints object or a named list containing \code{horder} and
\code{spouse}.}

\item{na_strings}{Vector of strings to be considered as NA values.}
}
\value{
A Pedigree object.
}
\description{
A pedigree is a ensemble of individuals linked to each other into
a family tree.
A Pedigree object store the informations of the individuals and the
special relationships between them. It also permit to store the
informations needed to plot the pedigree (i.e. scales and hints).

\subsection{Constructor :}{

Main constructor of the package.
This constructor help to create a \code{Pedigree} object from
different \code{data.frame} or a set of vectors.

If any errors are found in the data, the function will return
the data.frame with the errors of the Ped object and the
Rel object.
}
}
\details{
If the normalization is set to \code{TRUE}, then the data will be
standardized using the function \code{norm_ped()} and \code{norm_rel()}.

If a data.frame is given, the columns names needed are as follow:
\itemize{
\item \code{id}: the individual identifier
\item \code{dadid}: the identifier of the biological father
\item \code{momid}: the identifier of the biological mother
\item \code{famid}: the family identifier of the individual
\item \code{sex}: the sex of the individual
\item \code{fertility}: the fertility status of the individual
\item \code{miscarriage}: the miscarriage status of the individual
\item \code{deceased}: the death status of the individual
\item \code{avail}: the availability status of the individual
\item \code{evaluated}: the evaluation status of the individual
\item \code{consultand}: the consultand status of the individual
\item \code{proband}: the proband status of the individual
\item \code{affection}: the affection status of the individual
\item \code{carrier}: the carrier status of the individual
\item \code{asymptomatic}: the asymptomatic status of the individual
\item \code{adopted}: the adopted status of the individual
\item \code{dateofbirth}: the date of birth of the individual
\item \code{dateofdeath}: the date of death of the individual
\item \code{...}: other columns that will be stored in the
\code{elementMetadata} slot
}

The minimum columns required are :
\itemize{
\item \code{id}
\item \code{dadid}
\item \code{momid}
\item \code{sex}
}

The \code{famid} column can also be used to specify the
family of the individuals and will be merge to the
\code{id} field separated by an underscore.

The columns \code{deceased}, \code{avail},
\code{evaluated}, \code{consultand},
\code{proband}, \code{carrier},
\code{asymptomatic}, \code{adopted}
will be transformed with the \code{\link[=vect_to_binary]{vect_to_binary()}}
function when the normalisation is selected.

The \code{fertility} column will be transformed with the
\code{\link[=fertility_to_factor]{fertility_to_factor()}} function.

The \code{miscarriage} column will be transformed with the
\code{\link[=miscarriage_to_factor]{miscarriage_to_factor()}} function.

The \code{dateofbirth} and \code{dateofdeath} columns will be transformed
with the \code{\link[=char_to_date]{char_to_date()}} function.

If \code{affections} is a data.frame, \strong{col_aff} will be
overwritten by the column names of the data.frame.
}
\section{Slots}{

\describe{
\item{\code{ped}}{A Ped object for the identity informations.
See \code{\link[=Ped]{Ped()}} for more informations.}

\item{\code{rel}}{A Rel object for the special relationships.
See \code{\link[=Rel]{Rel()}} for more informations.}

\item{\code{scales}}{A Scales object for the filling and bordering
colors used in the plot.
See \code{\link[=Scales]{Scales()}} for more informations.}

\item{\code{hints}}{A Hints object for the ordering of the
individuals in the plot.
See \code{\link[=Hints]{Hints()}} for more informations.}
}}

\section{Accessors}{

\itemize{
\item \code{ped(x, slot)} : Get the value of a specific slot of the Ped object
}


\itemize{
\item \code{ped(x)} : Get the Ped object
}


\itemize{
\item \code{ped(x, slot) <- value} : Set the value of a specific slot of
the Ped object
Wrapper of \code{slot(ped(x)) <- value}
}


\itemize{
\item \code{ped(x) <- value} : Set the Ped object
}


\itemize{
\item \code{mcols(x)} : Get the metadata of a Pedigree object.
This function is a wrapper around \code{mcols(ped(x))}.
}


\itemize{
\item \code{mcols(x) <- value} : Set the metadata of a Pedigree object.
This function is a wrapper around \code{mcols(ped(x)) <- value}.
}


\itemize{
\item \code{rel(x, slot)} : Get the value of a specific slot of the Rel object
}


\itemize{
\item \code{rel(x)} : Get the Rel object
}


\itemize{
\item \code{rel(x, slot) <- value} : Set the value of a specific slot of the
Rel object
Wrapper of \code{slot(rel(x)) <- value}
}


\itemize{
\item \code{rel(x) <- value} : Set the Rel object
}


\itemize{
\item \code{scales(x)} : Get the Scales object
}


\itemize{
\item \code{scales(x) <- value} : Set the Scales object
}


\itemize{
\item \code{fill(x)} : Get the fill data.frame from the Scales object.
Wrapper of \code{fill(scales(x))}
}


\itemize{
\item \code{fill(x) <- value} : Set the fill data.frame from the Scales object.
Wrapper of \code{fill(scales(x)) <- value}
}


\itemize{
\item \code{border(x)} : Get the border data.frame from the Scales object.
Wrapper of \code{border(scales(x))}
}


\itemize{
\item \code{border(x) <- value} : Set the border data.frame
from the Scales object.
Wrapper of \code{border(scales(x)) <- value}
}


\itemize{
\item \code{hints(x)} : Get the Hints object
}


\itemize{
\item \code{hints(x) <- value} : Set the Hints object
}


\itemize{
\item \code{horder(x)} : Get the horder vector from the Hints object.
Wrapper of \code{horder(hints(x))}
}


\itemize{
\item \code{horder(x) <- value} : Set the horder vector from the Hints object.
Wrapper of \code{horder(hints(x)) <- value}
}


\itemize{
\item \code{spouse(x)} : Get the spouse data.frame from the Hints object.
Wrapper of \code{spouse(hints(x))}.
}


\itemize{
\item \code{spouse(x) <- value} : Set the spouse data.frame
from the Hints object.
Wrapper of \code{spouse(hints(x)) <- value}.
}
}

\section{Generics}{

\itemize{
\item \code{length(x)}: Get the length of a Pedigree object.
Wrapper of \code{length(ped(x))}.
}


\itemize{
\item \code{show(x)}: Print the information of the Ped and Rel
object inside the Pedigree object.
}


\itemize{
\item \code{summary(x)}: Compute the summary of the Ped and Rel object
inside the Pedigree object.
}


\itemize{
\item \code{as.list(x)}: Convert a Pedigree object to a list
}


\itemize{
\item \code{subset(x, i, keep = TRUE)}: Subset a Pedigree object
based on the individuals identifiers given.
\itemize{
\item \code{i} : A vector of individuals identifiers to keep.
\item \code{del_parents} : A logical value indicating if the parents
of the individuals should be deleted.
\item \code{keep} : A logical value indicating if the individuals
should be kept or deleted.
}
}


\itemize{
\item \code{x[i, del_parents, keep]}: Subset a Pedigree object
based on the individuals identifiers given.
}
}

\examples{

Pedigree(
    obj = c("1", "2", "3", "4", "5", "6"),
    dadid = c("4", "4", "6", "0", "0", "0"),
    momid = c("5", "5", "5", "0", "0", "0"),
    sex = c(1, 2, 3, 1, 2, 1),
    avail = c(0, 1, 0, 1, 0, 1),
    affections = matrix(c(
        0, 1, 0, 1, 0, 1,
        1, 1, 1, 1, 1, 1
    ), ncol = 2),
    col_aff = c("aff1", "aff2"),
    missid = "0",
    rel_df = matrix(c(
        "1", "2", 2
    ), ncol = 3, byrow = TRUE),
)

data(sampleped)
Pedigree(sampleped)
}
\seealso{
\code{\link[=Pedigree]{Pedigree()}}
\code{\link[=Ped]{Ped()}}
\code{\link[=Rel]{Rel()}}
\code{\link[=Scales]{Scales()}}
\code{\link[=Hints]{Hints()}}

\code{\link[=Ped]{Ped()}}
\code{\link[=Rel]{Rel()}}
\code{\link[=Scales]{Scales()}}
}
