% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R, R/AllConstructor.R,
%   R/AllAccessors.R, R/AllGeneric.R
\docType{class}
\name{Hints-class}
\alias{Hints-class}
\alias{Hints}
\alias{Hints,Hints,missing_OR_NULL-method}
\alias{Hints,list,missing_OR_NULL-method}
\alias{Hints,numeric,data.frame-method}
\alias{Hints,missing_OR_NULL,data.frame-method}
\alias{Hints,numeric,missing_OR_NULL-method}
\alias{Hints,missing_OR_NULL,missing_OR_NULL-method}
\alias{horder}
\alias{horder,Hints-method}
\alias{horder<-}
\alias{horder<-,Hints-method}
\alias{spouse}
\alias{spouse,Hints-method}
\alias{spouse<-,Hints,data.frame-method}
\alias{as.list,Hints-method}
\alias{subset,Hints-method}
\title{Hints object}
\usage{
Hints(horder, spouse)

\S4method{Hints}{list,missing_OR_NULL}(horder, spouse)

\S4method{Hints}{numeric,data.frame}(horder, spouse)

\S4method{Hints}{missing_OR_NULL,data.frame}(horder, spouse)

\S4method{Hints}{numeric,missing_OR_NULL}(horder, spouse)
}
\arguments{
\item{horder}{A named numeric vector with one element per subject in the
Pedigree.  It determines the relative horizontal order of subjects within a
sibship, as well as the relative order of processing for the founder couples.
(For this latter, the female founders are ordered as though
they were sisters).
The names of the vector should be the individual identifiers.}

\item{spouse}{A data.frame with one row per hinted marriage, usually only
a few marriages in a pedigree will need an added hint, for instance reverse
the plot order of a husband/wife pair.
Each row contains the id of the left spouse (i.e. \code{idl}), the id of the
right hand spouse (i.e. \code{idr}), and the anchor (i.e : \code{anchor} :
\code{1} = left, \code{2} = right, \code{0} = either).
Children will preferentially appear under the parents of the anchored spouse.}
}
\value{
A Hints object.
}
\description{
The hints are used to specify the order of the individuals in the pedigree
and to specify the order of the spouses.

\subsection{Constructor :}{

You either need to provide \strong{horder} or \strong{spouse} in
the dedicated parameters (together or separately), or inside a list.
}
}
\section{Slots}{

\describe{
\item{\code{horder}}{A numeric named vector with one element per subject in the
Pedigree.  It determines the relative horizontal order of subjects within
a sibship, as well as the relative order of processing for the founder
couples. (For this latter, the female founders are ordered as though they
were sisters).}

\item{\code{spouse}}{A data.frame with one row per hinted marriage, usually
only a few marriages in a Pedigree will need an added hint, for
instance reverse the plot order of a husband/wife pair.
Each row contains the identifiers of the left spouse, the right hand spouse,
and the anchor (i.e : \code{1} = left, \code{2} = right, \code{0} = either).}
}}

\section{Accessors}{

\itemize{
\item \code{horder(x)} : Get the horder vector
}


\itemize{
\item \code{horder(x) <- value} : Set the horder vector
}


\itemize{
\item \code{spouse(x)} : Get the spouse data.frame
}


\itemize{
\item \code{spouse(x) <- value} : Set the spouse data.frame
}
}

\section{Generics}{

\itemize{
\item \code{as.list(x)}: Convert a Hints object to a list
}


\itemize{
\item \code{subset(x, i, keep = TRUE)}: Subset a Hints object
based on the individuals identifiers given.
\itemize{
\item \code{i} : A vector of individuals identifiers to keep.
\item \code{keep} : A logical value indicating if the individuals
should be kept or deleted.
}
}
}

\examples{

Hints(
    list(
        horder = c("1" = 1, "2" = 2, "3" = 3),
        spouse = data.frame(
            idl = c("1", "2"),
            idr = c("2", "3"),
            anchor = c(1, 2)
        )
    )
)

Hints(
    horder = c("1" = 1, "2" = 2, "3" = 3),
    spouse = data.frame(
        idl = c("1", "2"),
        idr = c("2", "3"),
        anchor = c(1, 2)
    )
)

Hints(
    horder = c("1" = 1, "2" = 2, "3" = 3),
    spouse = data.frame(
        idl = c("1", "2"),
        idr = c("2", "3"),
        anchor = c(1, 2)
    )
)

Hints(
    horder = c("1" = 1, "2" = 2, "3" = 3)
)
}
\seealso{
\code{\link[=Pedigree]{Pedigree()}}
}
