% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeacoQC.R
\name{RemoveMargins}
\alias{RemoveMargins}
\title{Remove margin events of flow cytometry data}
\usage{
RemoveMargins(ff, channels,
channel_specifications=NULL, output="frame")
}
\arguments{
\item{ff}{A flowframe that contains flow cytometry data.}

\item{channels}{The channel indices or channel names that have to be checked
for margin events}

\item{channel_specifications}{A list of vectors with parameter specifications
for certain channels. This parameter should only be used if the values in
the internal parameters description is too strict or wrong for a number or
all channels. This should be one list per channel with first a minRange and
then a maxRange value in a vector. This list should have the channel name
found back in \code{colnames(flowCore::exprs(ff))}. If a channel is not
listed in this parameter, its default internal values will be used. The
default of this parameter is NULL.}

\item{output}{If set to "full", a list with the filtered flowframe and the
indices of the margin event is returned. If set to "frame", only the
filtered flowframe is returned. The default is "frame".}
}
\value{
This function returns either a filtered flowframe when the
\code{output} parameter is set to "frame" or a list containing the filtered
flowframe and a TRUE/FALSE list indicating the margin events. An extra column
named "Original_ID" is added to the flowframe where the cells are given their
 original cell id.
}
\description{
\code{RemoveMargins} will remove margin events from the
flowframe based on the internal description of the fcs file.
}
\examples{
# Read in raw data
fileName <- system.file("extdata", "111.fcs", package="PeacoQC")
ff <- flowCore::read.FCS(fileName)

# Define channels where the margin events should be removed
channels <- c(1, 3, 5:14, 18, 21)

# Remove margins

ff_cleaned <- RemoveMargins(ff, channels)

# If an internal value is wrong for a channels (e.g. FSC-A)

channel_specifications <- list("FSC-A"=c(-111, 262144),
                               "SSC-A"=c(-111, 262144))
ff_cleaned <- RemoveMargins(
    ff,
    channels,
    channel_specifications=channel_specifications)
}
