% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizationPlots.R
\name{plot_intragroup_correlation}
\alias{plot_intragroup_correlation}
\title{Plot intragroup correlation of the normalized data}
\usage{
plot_intragroup_correlation(
  se,
  ain = NULL,
  condition = NULL,
  method = "pearson"
)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{ain}{Vector of strings which assay should be used as input (default NULL).
If NULL then all normalization of the se object are plotted next to each other.}

\item{condition}{column name of condition (if NULL, condition saved in SummarizedExperiment will be taken)}

\item{method}{String specifying the method for correlation calculation (pearson, spearman or kendall)}
}
\value{
ggplot object (boxplot)
}
\description{
Plot intragroup correlation of the normalized data
}
\examples{
data(tuberculosis_TMT_se)
plot_intragroup_correlation(tuberculosis_TMT_se, ain = NULL,
                            condition = NULL, method = "pearson")

}
