% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaBatch.R
\name{PomaBatch}
\alias{PomaBatch}
\title{Batch Correction}
\usage{
PomaBatch(data, batch, mod = NULL)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{batch}{Character. The name of the column in \code{colData} that contains the batch information.}

\item{mod}{Character vector. Indicates the names of \code{colData} columns to be included as covariates. Default is NULL (no covariates).}
}
\value{
A \code{SummarizedExperiment} object with batch-corrected data.
}
\description{
\code{PomaBatch} performs batch correction on a \code{SummarizedExperiment} object given a batch factor variable.
}
\examples{
# Output is a batch corrected SummarizedExperiment object
data <- POMA::st000284 # Example SummarizedExperiment object included in POMA

data \%>\%
  PomaBatch(batch = "gender")
}
\references{
Leek JT, Johnson WE, Parker HS, Fertig EJ, Jaffe AE, Zhang Y, Storey JD, Torres LC (2023). sva: Surrogate Variable Analysis. doi:10.18129/B9.bioc.sva \url{https://doi.org/10.18129/B9.bioc.sva}
}
\author{
Pol Castellano-Escuder
}
