% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsda_batch.R
\name{PLSDA}
\alias{PLSDA}
\title{Partial Least Squares Discriminant Analysis}
\usage{
PLSDA(X, Y, ncomp, keepX = rep(ncol(X), ncomp), tol = 1e-06, max.iter = 500)
}
\arguments{
\item{X}{A numeric matrix that is centered and scaled as an explanatory
matrix. \code{NA}s are not allowed.}

\item{Y}{A dummy matrix that is centered and scaled as an outcome matrix.}

\item{ncomp}{Integer, the number of dimensions to include in the model.}

\item{keepX}{A numeric vector of length \code{ncomp}, the number of variables
to keep in \eqn{X}-loadings. By default all variables are kept in the model.
A valid input of \code{keepX} extends \code{PLSDA} to a sparse version.}

\item{tol}{Numeric, convergence stopping value.}

\item{max.iter}{Integer, the maximum number of iterations.}
}
\value{
\code{PLSDA} returns a list that contains the following components:

\item{original_data}{The original explanatory matrix \code{X} and outcome
matrix \code{Y}.}
\item{defl_data}{The centered and scaled deflated matrices (\eqn{\hat{X}}
and \eqn{\hat{Y}}) after removing the variance of latent components
calculated with estimated latent dimensions.}
\item{latent_comp}{The latent components calculated with estimated
latent dimensions.}
\item{loadings}{The estimated latent dimensions.}
\item{iters}{Number of iterations of the algorthm for each component.}
\item{exp_var}{The amount of data variance explained per component (note
that contrary to \code{PCA}, this amount may not decrease as the aim of the
method is not to maximise the variance, but the covariance between
\code{X} and the dummy matrix \code{Y}).}
}
\description{
This function estimates latent dimensions from the explanatory matrix
\code{X}. The latent dimensions are maximally associated with the outcome
matrix \code{Y}. It is a built-in function of \code{PLSDA_batch}.
}
\examples{
# A built-in function of PLSDA_batch, not separately used.
# Not run
data('AD_data')
library(mixOmics)
library(TreeSummarizedExperiment)

X <- assays(AD_data$EgData)$Clr_value
Y.trt <- rowData(AD_data$EgData)$Y.trt
names(Y.trt) <- rownames(AD_data$EgData)

X.scale <- scale(X, center = TRUE, scale = TRUE)

# convert Y.trt to be a dummy matrix
Y.trt.mat <- unmap(as.numeric(Y.trt))
Y.trt.scale <- scale(Y.trt.mat, center = TRUE, scale = TRUE)

ad_plsda.trt <- PLSDA(X.scale, Y.trt.scale, ncomp = 1)
# the latent components associated with Y.trt:
X.compnt <- ad_plsda.trt$latent_comp$t


}
\references{
\insertRef{barker2003partial}{PLSDAbatch}
}
\author{
Yiwen Wang, Kim-Anh Lê Cao
}
\keyword{Internal}
