% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIUMA_ImportSE.R
\name{makeTDAobjFromSE}
\alias{makeTDAobjFromSE}
\title{Import SummarizedExperiment data and generate the TDAobj object}
\usage{
makeTDAobjFromSE(SE, outcomes)
}
\arguments{
\item{SE}{A \code{SummarizedExperiment} object}

\item{outcomes}{A string or vector of string containing the name of variables
that have to be considered 'outcomes'}
}
\value{
A TDA object containing:
\itemize{
  \item  orig_data A data.frame of original data (without outcomes)
  \item  scaled_data A data.frame of re-scaled data (without outcomes)
  \item  outcomeFact A data.frame of original outcomes
  \item  outcome A data.frame of original outcomes converted as numeric
  \item  comp A data.frame containing the components of projected data
  \item  dist_mat A data.frame containing the computed distance matrix
  \item  dfMapper A data.frame containing the nodes, with their elements,
identified by TDA
  \item  jacc A matrix of Jaccard indexes between each pair of dfMapper nodes
  \item  node_data_mat A data.frame with the node size and the average value
  }
}
\description{
This function import a \code{SummarizedExperiment} object
and create
 the object to store all data needed for TDA analysis. In addition, some
 preliminary preprocess steps are performed; specifically, outcomes
 variables data will be separated the rest of dataset.
 The remaining dataset will be also re-scaled (0-1)
}
\examples{
## use example data:
data("vascEC_meta")
data("vascEC_norm")
suppressMessages(library(SummarizedExperiment))
dataSE <- SummarizedExperiment(assays=as.matrix(t(vascEC_norm)),
                              colData=as.data.frame(vascEC_meta))
res <- makeTDAobjFromSE(dataSE, "zone")

}
\author{
Mattia Chiesa, Laura Ballarini, Luca Piacentini
}
