% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-validateModel.R
\name{validateModel}
\alias{validateModel}
\title{Perform Validation on an \code{S4} Object Representing a Trained Model}
\usage{
validateModel(model, valData, ...)
}
\arguments{
\item{model}{An \code{S4} object.}

\item{valData}{\code{Any} Data to verify the model with.}

\item{...}{Allow new parameters to be defined for this generic.}
}
\value{
The \code{S4} object with added model performance metadata.
}
\description{
Perform Validation on an \code{S4} Object Representing a Trained Model
}
\examples{
data(sampleTrainedPCOSPmodel)
data(samplePCOSPpredList)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Validate model
validatedPCOSPmodel <- validateModel(sampleTrainedPCOSPmodel,
  valData=samplePCOSPpredList[[1]])

}
