% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-trainModel.R
\name{trainModel,PCOSP-method}
\alias{trainModel,PCOSP-method}
\title{Train a PCOSP Model Based on The Data the assay \code{trainMatrix}.}
\usage{
\S4method{trainModel}{PCOSP}(object, numModels = 10, minAccuracy = 0.6, ...)
}
\arguments{
\item{object}{A \code{PCOSP} object to train.}

\item{numModels}{An \code{integer} specifying the number of models to train.
Defaults to 10. We recommend using 1000+ for good results.}

\item{minAccuracy}{A \code{float} specifying the balanced accurary required
to consider a model 'top scoring'. Defaults to 0.6. Must be in the
range [0, 1].}

\item{...}{Fall through arguments to \code{BiocParallel::bplapply}. Use this to
configure parallelization options. By default the settings inferred in
\code{BiocParallel::bpparam()} will be used.}
}
\value{
A \code{PCOSP} object with the trained model in the \code{model} slot.
}
\description{
Uses the switchBox SWAP.Train.KTSP function to fit a number of k top scoring
pair models to the data, filtering the results to the best models based
on the specified paramters.
}
\details{
This function is parallelized with BiocParallel, thus if you wish
to change the back-end for parallelization, number of threads, or any
other parallelization configuration please pass BPPARAM to bplapply.
}
\examples{
data(samplePCOSPmodel)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

set.seed(getModelSeed(samplePCOSPmodel))
trainModel(samplePCOSPmodel, numModels=2, minAccuracy=0.6)

}
\seealso{
switchBox::SWAP.KTSP.Train BiocParallel::bplapply
}
