% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-trainModel.R
\name{trainModel,NCSModel-method}
\alias{trainModel,NCSModel-method}
\title{Train a NetworkCommunitySearchModel}
\usage{
\S4method{trainModel}{NCSModel}(object, alpha = 0.05, minRepro = 0.5, minCor = 0)
}
\arguments{
\item{object}{An \code{NCSModel} object, created from a
\code{ConsensusMetaclusteringModel}.}

\item{alpha}{A \code{float} specifying the significance level for cluster
reproducibility. Default is 0.05.}

\item{minRepro}{A \code{float} specifying the minimum in-group proportion (IGP)
for a cluster to be included in the metacluster labels. Default is 0.5.}

\item{minCor}{A \code{float} specifying the minimum correlation between a
centroid and assay cluster to be included in the metacluster labels.
Default is 0.0.}
}
\value{
The \code{NCSModel} from \code{object} with the \code{networkEdges} item of the
\code{models} slot fitlered based on the specified criteria. The criteria are
also stored in the \code{modelParam} slots to ensure reproducibility.
}
\description{
Train a NetworkCommunitySearchModel
}
