% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-trainModel.R
\name{trainModel,ConsensusMetaclusteringModel-method}
\alias{trainModel,ConsensusMetaclusteringModel-method}
\title{Train A ConsensusMetaclusteringModel}
\usage{
\S4method{trainModel}{ConsensusMetaclusteringModel}(
  object,
  maxK = 5,
  reps = 10,
  distance = "pearson",
  clusterAlg = "hc",
  plot = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{ConsensusMetaclusteringModel} to train.}

\item{maxK}{The maximum number of clusters to test. Defaults to 5.}

\item{reps}{How many random samples should clustering be repeated on? Default
is 10, but 1000+ is recommended for real world use.}

\item{distance}{The distance method to use. Defaults to 'pearson'. See
\code{?ConsensusClusterPlus::ConsensusClusterPlus} for more options.}

\item{clusterAlg}{The clustering algorithm to use. Defaults to 'hc'. See
\code{?ConesnsusClusterPLus::ConsensusClusterPlus} for more options.}

\item{plot}{An optional path to output the plots generated by each
call to \code{ConsensusClusterPlus::ConsensusClusterPlus}. Default is NULL,
which suppresses all plots, otherwise passed to the clustering function.}

\item{...}{Fall through parameters to \code{BiocParallel::bplapply}. This can
be used to customize your parallelization using BPPARAM or to pass
additional arguments to \code{ConsensusClusterPlus}.}
}
\value{
The \code{ConsensusMetaclusteringModel} with the clustering results in the
\code{models} slot.
}
\description{
Since consensus clustering is an unsuperived learning method, there isn't
really a 'training step' per se. Instead this method computes the consensus
clusters and stores the results in the \code{models} slot.
}
