% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-rankFeatures.R
\name{rankFeatures,MultiAssayExperiment-method}
\alias{rankFeatures,MultiAssayExperiment-method}
\title{Rank the Features in a \code{MultiAssayExperiment} Object}
\usage{
\S4method{rankFeatures}{MultiAssayExperiment}(
  object,
  FUN = "mad",
  RANK_FUN = "dense_rank",
  ...,
  descending = TRUE,
  weights
)
}
\arguments{
\item{object}{A \code{MultiAssayExperiment} to rank the features in.}

\item{FUN}{A vectorized feature scoring function, such as \code{var} or \code{mad}.
Defaults to \code{mad} from the \code{BiocGenerics} package.}

\item{RANK_FUN}{A ranking function, such as \code{rank} or \code{dense_rank}. Defaults
to \code{dense_rank} from \code{dplyr}.}

\item{...}{Fall through arguments to \code{FUN}, such as \code{na.rm=TRUE}.}

\item{descending}{Should your rank function be called with \code{-} before the
values from \code{FUN}. Defaults to \code{TRUE}, which should be used if high values
returned from \code{FUN} are good.}

\item{weights}{A named \code{numeric} weighting vector with a weight for each
experiment in the \code{MultiAssayExperiment} object. Names must match the
\code{names(experiments(object))}. Passed to \code{matrixStats::weightedMedian} when
aggregating feature scores per assay. Defaults to the sample size of an
assay relative to the largest sample size when this paramter is missing.}
}
\value{
The \code{MultiAssayExperiment} with the item \code{featureRanks} in the object
metadata, which stores a \code{DataFrame} containing ranks accross all assays for
each unique feature and the additional columns \code{feature_score} and \code{feature_rank},
as calculated with \code{FUN} and \code{RANK_FUN}, respectively. Information
about which functions were used for each column can be found in the object
\code{mcols} in the \code{calculated_with} column.
}
\description{
Rank the Features in a \code{MultiAssayExperiment} Object
}
\seealso{
\code{\link[BiocGenerics:mad]{BiocGenerics::mad}}, \code{\link[dplyr:ranking]{dplyr::dense_rank}},
\code{\link[matrixStats:weightedMedian]{matrixStats::weightedMedian}}
}
