% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-predictClasses.R
\name{predictClasses}
\alias{predictClasses}
\title{Predict Classes for New Data Based on a Train Classifier Model}
\usage{
predictClasses(object, model, ...)
}
\arguments{
\item{object}{An \code{S4} object containing data to predict classes from.}

\item{model}{An \code{S4} object containing one or more trained classification
models.}

\item{...}{Allow further parameters to be defined on this generic.}
}
\value{
The \code{S4} object with class predictions added to the metadata.
}
\description{
Predict Classes for New Data Based on a Train Classifier Model
}
\examples{
data(sampleTrainedPCOSPmodel)
data(samplePCSIsurvExp)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Make predictions
PCOSPpredSurvExp <- predictClasses(samplePCSIsurvExp,
  model=sampleTrainedPCOSPmodel)
head(colData(PCOSPpredSurvExp))

}
