% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-predictClasses.R
\name{predictClasses,ConsensusMetaclusteringModel,ANY-method}
\alias{predictClasses,ConsensusMetaclusteringModel,ANY-method}
\title{Compute the Optimal Clustering Solution for a Trained
ConsensusMetaclusteringModel}
\usage{
\S4method{predictClasses}{ConsensusMetaclusteringModel,ANY}(object, ..., optimal_k_function = optimalKMinimizeAmbiguity)
}
\arguments{
\item{object}{A \code{MutliAssayExperiment} object}

\item{...}{Fall through arguments to \code{optimal_k_function}. For the default
\code{optimal_k_function}, you can specify \code{subinterval} argument which defines
the interval of the ECDF to minimize ambiguity over. Defaults to \code{c(0.1, 0.9)}
if not specified. See \code{?optimalKMinimizeAmbiguity} for more details on
the \code{subinterval} parameter.}

\item{optimal_k_function}{A function which accepts as its input \code{models(object)}
of a trained \code{ConsensusMetaclusteringModel} object, and returns a vector
of optimal K values, one for each assay in \code{rawdata(object)}. The default
method is \code{optimalKMinimizeAmbiguity}, see \code{?optimalKMinimizeAmbiguity}
for more details. Please note this argument must be named or it will not
work.}
}
\value{
A \code{object} \code{ConsensusMetaclusteringModel}, with class predictions
assigned to the colData of \code{trianData}
}
\description{
Compute the optimal clustering solution out of possibilities generated
with trainModel. Assigns the cluster labels to the \code{MultiAssayExperiment}
object.
}
