% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-plotSurvivalCurves.R
\name{plotSurvivalCurves,CoxModel-method}
\alias{plotSurvivalCurves,CoxModel-method}
\title{Plot Survival Curves from a Fit \code{CoxModel} Object}
\usage{
\S4method{plotSurvivalCurves}{CoxModel}(object, byCohort = TRUE, ..., facet.by = "cohort")
}
\arguments{
\item{object}{A \code{CoxModel} object with survival curves fit via the
\code{trainModel} method.}

\item{byCohort}{\code{TRUE} to return a single plot object faceted by \code{facet.by},
\code{FALSE} to get a list of individual survival curves per cohort.}

\item{...}{Fall through parameters to \code{survminer::ggsurvplot} function.}

\item{facet.by}{What column of the object \code{modelDT} to use for faceting
the survival plot. Defaults to 'cohorts'. Only used if
\code{byCohort} is \code{TRUE}.}
}
\value{
A \code{ggplot} or \code{list} of ggplot objects containing the survival
curves for each cohort in the \code{trainData} slot of the \code{CoxModel}.
}
\description{
Plot Survival Curves from a Fit \code{CoxModel} Object
}
