% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-SurvivalExperiment.R
\name{SurvivalExperiment}
\alias{SurvivalExperiment}
\title{Constructor for \code{SurvivalExperiment} Class

Builds a \code{SurvivalExperiment} object, which is just a wrapper for a
\code{SummarizedExperiment} with mandatory survival metadata numeric columns
\code{survival_time} and \code{event_occurred}.}
\usage{
SurvivalExperiment(
  ...,
  survival_time = "survival_time",
  event_occurred = "event_occurred"
)
}
\arguments{
\item{...}{\code{pairlist} Fall through arguments to the \code{SummarizedExperiment}
constructor. If the first argument to dots is a \code{SummarizedExperiment},
that object is used instead.}

\item{survival_time}{A \code{character} vector indicating the column name in
\code{colData} which contains the \code{integer} number of days a patient
has survived since treatment at the time of data collection. If
\code{event_occurred} is 1/TRUE, then this is the number of days the patient lived.}

\item{event_occurred}{A \code{character} vector indicating the column name in
\code{colData} which contains \code{logical} or \code{integer} values where 0/FALSE means
a patient is alive and 1/TRUE means a patient is deceased.}
}
\value{
A \code{SurvivalExperiment} object.
}
\description{
Constructor for \code{SurvivalExperiment} Class

Builds a \code{SurvivalExperiment} object, which is just a wrapper for a
\code{SummarizedExperiment} with mandatory survival metadata numeric columns
\code{survival_time} and \code{event_occurred}.
}
\examples{
data(sampleICGCmicro)

# build a SurvivalExperiment from raw data
ICGCmicro <- SurvivalExperiment(assays=assays(sampleICGCmicro),
  rowData=rowData(sampleICGCmicro), colData=colData(sampleICGCmicro),
  metadata=metadata(sampleICGCmicro), survival_time='survival_time',
  event_occurred='event_occurred')

# build a SurvivalExperiment from an existig SummarizedExperment
ICGCmicroSumExp <- as(sampleICGCmicro, 'SummarizedExperiment')
ICGCmicro <- SurvivalExperiment(ICGCmicroSumExp,
  survival_time='survival_time', event_occurred='event_occurred')

}
