% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-ModelComparison.R
\name{ModelComparison}
\alias{ModelComparison}
\title{ModelComparison Constructor}
\usage{
ModelComparison(model1, model2, ...)
}
\arguments{
\item{model1}{An object with a \code{validationStats} method which returns a
\code{data.table}. Probably this object should inherit from \code{SurvivalModel}.}

\item{model2}{An object with a \code{validationStats} method which returns a
\code{data.table}. Probably this object should inherit from \code{SurvivalModel}.}

\item{...}{Not used.}
}
\value{
A \code{ModelComparison} object, which is a wrapper for \code{DataFrame}
which is used for method dispatch.
}
\description{
ModelComparison Constructor
}
\examples{
data(sampleValPCOSPmodel)
data(sampleClinicalModel)
data(sampleCohortList)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Train the models
trainedClinicalModel <- trainModel(sampleClinicalModel)

# Predict risk/risk-class
clinicalPredCohortL <- predictClasses(sampleCohortList[c('PCSI', 'TCGA')],
  model=trainedClinicalModel)

# Validate the models
validatedClinicalModel <- validateModel(trainedClinicalModel,
  valData=clinicalPredCohortL)

# Compare the models
modelComp <- ModelComparison(sampleValPCOSPmodel, validatedClinicalModel)
head(modelComp)

}
