% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-CohortList.R
\name{CohortList}
\alias{CohortList}
\title{Constructor for the CohortList class, a specialized list for storing
SurvivalExperiment objects.}
\usage{
CohortList(..., mDataTypes)
}
\arguments{
\item{...}{One or more \code{SurvivalExperiment} objects.}

\item{mDataTypes}{A \code{character} vector with the same length as ... which
indicates the molecular data type in each cohort. This will be assigned
to \code{mcols} for the \code{CohortList} as well as to the metadata of each
item in the list as \code{mDataType}.}
}
\value{
A \code{CohortList} object containing one or more \code{SurvivalExperiment}
objects.
}
\description{
Constructor for the CohortList class, a specialized list for storing
SurvivalExperiment objects.
}
\examples{
data(sampleICGCmicro)
set.seed(1987)
cohortList <- CohortList(list(survExp1=sampleICGCmicro,
  survExp2=sampleICGCmicro), mDataTypes=c('rna_micro', 'rna_micro'))

}
