% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_LD.R
\name{load_LD}
\alias{load_LD}
\title{Load Linkage Disequilibrium}
\usage{
load_LD(
  LD_file,
  LD_columns = c("Locus1", "Position1", "Site1", "Position2", "Site2", "Dist_bp",
    "R.2")
)
}
\arguments{
\item{LD_file}{The file containing linkage disequilibrium data}

\item{LD_columns}{The names of the columns in your linkage disequilibrium
data for the chromosome of the first SNP, the position of the first SNP,
the site of the first SNP, the chromosome of the second SNP, the position
of the second SNP, the site of the second SNP, the distance between the
two SNPs, and the R.2}
}
\value{
The linkage disequilibrium data in a list containing
  dataframes for each chromosome.
}
\description{
Load Linkage Disequilibrium
}
\examples{
demo_LD_file = system.file("extdata","LD.txt.xz",
  package = "PAST", mustWork = TRUE)
LD <- load_LD(demo_LD_file)
}
