% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_SNPs_to_genes.R
\name{assign_SNPs_to_genes}
\alias{assign_SNPs_to_genes}
\title{Assign SNPs to genes}
\usage{
assign_SNPs_to_genes(
  gwas_data,
  LD,
  gff_file,
  filter_type,
  window,
  r_squared_cutoff,
  num_cores
)
}
\arguments{
\item{gwas_data}{Merged association and effects data from merge_data()}

\item{LD}{Linkage disequilibrium data from parse_LD()}

\item{gff_file}{The path to a GFF file}

\item{window}{The search window for genes around the SNP}

\item{r_squared_cutoff}{The R^2 value used to determine SNP significance}

\item{num_cores}{The number of cores to use in parallelizing PAST}
}
\value{
A dataframe of genes from the SNP data
}
\description{
Assign SNPs to genes
}
\examples{
example("load_GWAS_data")
example("load_LD")
demo_genes_file = system.file("extdata", "genes.gff",
  package = "PAST", mustWork = TRUE)
filter_type = c("gene")
genes <-assign_SNPs_to_genes(gwas_data, LD, demo_genes_file, filter_type, 1000, 0.8, 2)
}
