% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairadise.R
\name{pairadise}
\alias{pairadise}
\title{pairadise}
\usage{
pairadise(
  pdat,
  nIter = 100,
  tol = 10^(-2),
  pseudocount = 0,
  seed = 12321,
  equal.variance = FALSE,
  numCluster = 2,
  BPPARAM = MulticoreParam(numCluster)
)
}
\arguments{
\item{pdat}{A PDseDataSet object}

\item{nIter}{Positive integer. Specifies the maximum number of iterations of the optimization
algorithm allowed. Default is nIter = 100}

\item{tol}{Positive number. Specifies the tolerance level for terminating the optimization
algorithm, defined as the difference in log-likelihood ratios between iterations. Default
is tol = 10^(-2)}

\item{pseudocount}{Positive number. Specifies a value for a pseudocount added to each
count at the beginning of the analysis. Default is pseudocount = 0}

\item{seed}{An integer to set seed.}

\item{equal.variance}{Are the group variances assumed equal? Default value is FALSE.}

\item{numCluster}{Number of clusters to use for parallel computing.}

\item{BPPARAM}{parallel parameters from package BiocParallel.}
}
\value{
A PDseDataSet object contains outputs from PAIRADISE algorithm.
}
\description{
Primary function of the PAIRADISE package. Analyzes matched pairs for differences in isoform expression.
Uses parallel processing to speed up computation.
}
\details{
This is the primary function of the PAIRADISE package that implements the PAIRADISE algorithm.
}
\examples{

#############################
## Example: Simulated data ##
#############################

set.seed(12345)
data("sample_dataset")
pdat <- PDseDataSetFromMat(sample_dataset)
pdat <- pairadise(pdat, numCluster =4)
results(pdat)
}
