% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontology.R
\name{walk_ontology_tree}
\alias{walk_ontology_tree}
\title{All nodes of a subtree starting from the selected nodes}
\usage{
walk_ontology_tree(
  terms,
  ancestors = TRUE,
  db_key = "go_basic",
  ids = TRUE,
  method = "gra",
  relations = c("is_a", "part_of", "occurs_in", "regulates", "positively_regulates",
    "negatively_regulates")
)
}
\arguments{
\item{terms}{Character vector of ontology term IDs or names. A mixture of
IDs and names can be provided.}

\item{ancestors}{Logical: if \code{FALSE} the ontology tree is traversed
towards the leaf nodes; if \code{TRUE}, the tree is traversed until
the root. The former returns the ancestors (parents), the latter
the descendants (children).}

\item{db_key}{Character: key to identify the ontology database. For the
available keys see \code{\link{omnipath_show_db}}.}

\item{ids}{Logical: whether to return IDs or term names.}

\item{method}{Character: either "gra" or "lst". The implementation to use
for traversing the ontology tree. The graph based implementation is
faster than the list based, the latter will be removed in the future.}

\item{relations}{Character vector of ontology relation types. Only these
relations will be used.}
}
\value{
Character vector of ontology IDs. If the input terms are all
    leaves or roots \code{NULL} is returned. The starting nodes won't
    be included in the result unless they fall onto the traversal path
    from other nodes.
}
\description{
Starting from the selected nodes, recursively walks the ontology tree
until it reaches either the root or leaf nodes. Collects all visited
nodes.
}
\details{
Note: this function relies on the database manager, the first call might
take long because of the database load process. Subsequent calls within
a short period should be faster. See \code{\link{get_ontology_db}}.
}
\examples{
walk_ontology_tree(c('GO:0006241', 'GO:0044211'))
# [1] "GO:0006139" "GO:0006220" "GO:0006221" "GO:0006241" "GO:0006725"
# [6] "GO:0006753" "GO:0006793" "GO:0006796" "GO:0006807" "GO:0008150"
# ... (truncated)
walk_ontology_tree(c('GO:0006241', 'GO:0044211'), ancestors = FALSE)
# [1] "GO:0044210" "GO:0044211"
walk_ontology_tree(
    c('GO:0006241', 'GO:0044211'),
    ancestors = FALSE,
    ids = FALSE
)
# [1] "'de novo' CTP biosynthetic process" "CTP salvage"

}
\seealso{
\itemize{
    \item{\code{\link{omnipath_show_db}}}
    \item{\code{\link{get_ontology_db}}}
}
}
