% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_signaling_network_evex}
\alias{nichenet_signaling_network_evex}
\title{NicheNet signaling network from EVEX}
\usage{
nichenet_signaling_network_evex(top_confidence = 0.75, indirect = FALSE, ...)
}
\arguments{
\item{top_confidence}{Double, between 0 and 1. Threshold based on the
quantile of the confidence score.}

\item{indirect}{Logical: whether to include indirect interactions.}

\item{...}{Ignored.}
}
\value{
A network data frame (tibble) with signaling interactions
    suitable for use with NicheNet.
}
\description{
Builds signaling network prior knowledge for NicheNet from the EVEX
database.
}
\examples{
ev_signaling_network <- nichenet_signaling_network_evex(
    top_confidence = .9
)

}
\seealso{
\itemize{
    \item{\code{\link{evex_download}}}
    \item{\code{\link{nichenet_signaling_network}}}
}
}
