% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bma.R
\name{bma_motif_vs}
\alias{bma_motif_vs}
\title{Prints a BMA motif to the screen from a sequence of nodes, which can be
copy/pasted into the BMA canvas}
\usage{
bma_motif_vs(node_seq, G)
}
\arguments{
\item{node_seq}{An igraph node sequence.}

\item{G}{An igraph graph object.}
}
\value{
Character: BMA motifs as a single string.
}
\description{
Intended to parallel print_path_vs
}
\examples{
interactions <- omnipath(resources = "ARN")
graph <- interaction_graph(interactions)
bma_string <- bma_motif_vs(
    igraph::all_shortest_paths(
        graph,
        from = 'ULK1',
        to = 'ATG13'
    )$res,
    graph
)

}
