% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOMAGroup.R
\name{getOMAGroup}
\alias{getOMAGroup}
\title{Retrieve an OMA Group from the OMA Browser}
\usage{
getOMAGroup(id, attribute = NULL)
}
\arguments{
\item{id}{An identifier for the group. See above for possible types of IDs.}

\item{attribute}{an extra attribute to be returned (close_groups)}
}
\value{
an object containing the JSON keys as attributes or a dataframe
}
\description{
This function obtains an OMA Group from the OMA Browser database. An OMA Group
is defined to be a clique of proteins that are all orthologous to each other,
i.e. they are all related through speciation events only. An OMA Group can thus
by definition not contain any inparalogs. It is a very stringent orthology
grouping approach.
OMA Groups are mostly useful to infer phylogenetic species tree where they
can be used as marker genes.
}
\details{
Retrieving an OMA Group can be done using a group nr as id, its fingerprint
(a 7mer AA sequence which is unique to proteins in that group), a member
protein id or any sequence pattern that is unique to the group.
}
\examples{
getOMAGroup(id='58')
getOMAGroup(id='P12345')
getOMAGroup(id='NNRRGRI')
getOMAGroup(id='58', attribute='close_groups')
}
