% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges_helpers.R
\name{txSeqsFromFa}
\alias{txSeqsFromFa}
\title{Get transcript sequence from a GRangesList and a faFile or BSgenome}
\usage{
txSeqsFromFa(grl, faFile, is.sorted = FALSE, keep.names = TRUE)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} object}

\item{faFile}{\code{\link{FaFile}}, BSgenome, fasta/index file path or an
ORFik \code{\link{experiment}}. This file is usually used to find the
transcript sequences from some GRangesList.}

\item{is.sorted}{a speedup, if you know the grl ranges are sorted}

\item{keep.names}{a logical, default (TRUE), if FALSE: return as
character vector without names.}
}
\value{
a \code{\link{DNAStringSet}} of the transcript sequences
}
\description{
For each GRanges object, find the sequence of it from faFile or BSgenome.
}
\details{
A wrapper around \code{\link{extractTranscriptSeqs}} that works for
DNAStringSet and ORFik \code{\link{experiment}} input.
For debug of errors do:
which(!(unique(seqnamesPerGroup(grl, FALSE)) %in% seqlevels(faFile)))
This happens usually when the grl contains chromsomes that the fasta
file does not have. A normal error is that mitocondrial chromosome is
called MT vs chrM even though they have same seqlevelsStyle. The
above line will give you which chromosome it is missing.
}
\seealso{
Other ExtendGenomicRanges: 
\code{\link{asTX}()},
\code{\link{coveragePerTiling}()},
\code{\link{extendLeaders}()},
\code{\link{extendTrailers}()},
\code{\link{reduceKeepAttr}()},
\code{\link{tile1}()},
\code{\link{windowPerGroup}()}
}
\concept{ExtendGenomicRanges}
