% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txdbHelpers.R
\name{txNamesToGeneNames}
\alias{txNamesToGeneNames}
\title{Convert transcript names to gene names}
\usage{
txNamesToGeneNames(txNames, txdb)
}
\arguments{
\item{txNames}{character vector, the transcript names to convert. Can also be
a named object with tx names (like a GRangesList), will then extract names.}

\item{txdb}{the transcript database to use or gtf/gff path to it.}
}
\value{
character vector of gene names
}
\description{
Works for ensembl, UCSC and other standard annotations.
}
\examples{
df <- ORFik.template.experiment()
txdb <- loadTxdb(df)
loadRegions(txdb, "cds") # using tx names
txNamesToGeneNames(cds, txdb)
# Identical to:
loadRegions(txdb, "cds", by = "gene")
}
