% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_directory_config.R
\name{list.genomes}
\alias{list.genomes}
\title{List genomes created with ORFik}
\usage{
list.genomes(reference.folder = ORFik::config()["ref"])
}
\arguments{
\item{reference.folder}{character path, default:
\code{ORFik::config()["ref"]}.}
}
\value{
a data.table with 5 columns:\cr
 - character (name of folder)\cr
 - logical (does it have a gtf)\cr
 - logical (does it have a fasta genome)\cr
 - logical (does it have a STAR index)\cr
 - logical (only displayed if some are TRUE, does it have protein structure
  predictions of ORFs from alphafold etc, in folder called
  'protein_structure_predictions')\cr
 - logical (only displayed if some are TRUE, does it have gene symbol fst file
   from bioMart etc, in file called 'gene_symbol_tx_table.fst')
}
\description{
Given the reference.folder, list all valid references.
An ORFik genome is defined as a folder with a file called output.rds
that is a named R vector with names gtf and genome, where the values
are character paths to those files inside that folder. This makes sure
that this reference was made by ORFik and not some other program.
}
\examples{
## Run with default config path
#list.genomes()
## Run with custom config path
list.genomes(tempdir())
## Get the path to fasta genome of first organism in list
#readRDS(file.path(config()["ref"], list.genomes()$name, "outputs.rds")[1])["genome"]
}
