% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_exports.R
\name{export.bed12}
\alias{export.bed12}
\title{Export as bed12 format}
\usage{
export.bed12(grl, file, rgb = 0)
}
\arguments{
\item{grl}{A GRangesList}

\item{file}{a character path to valid output file name}

\item{rgb}{integer vector, default (0), maximum (255),
either single integer or vector of same size as grl to specify groups.
It is adviced to not use more than 8 different groups. (In IGV / UCSC
0 is black and 255 is blue)}
}
\value{
invisible(NULL) (File is saved only)
}
\description{
bed format for multiple exons per group, as transcripts.
Can be use as alternative as a sparse .gff format for ORFs.
Can be direct input for ucsc browser or IGV
}
\details{
If grl has no names, groups will be named 1,2,3,4..
}
\examples{
grl <- GRangesList(GRanges("1", c(1,3,5), "+"))
}
\references{
\url{https://bedtools.readthedocs.io/en/latest/content/general-usage.html#bed-format}
}
\seealso{
Other utils: 
\code{\link{bedToGR}()},
\code{\link{convertToOneBasedRanges}()},
\code{\link{export.bigWig}()},
\code{\link{export.fstwig}()},
\code{\link{export.wiggle}()},
\code{\link{fimport}()},
\code{\link{findFa}()},
\code{\link{fread.bed}()},
\code{\link{optimizeReads}()},
\code{\link{readBam}()},
\code{\link{readBigWig}()},
\code{\link{readWig}()}
}
\concept{utils}
