% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORFs_annotations.R
\name{defineIsoform}
\alias{defineIsoform}
\title{Overlaps GRanges object with provided annotations.}
\usage{
defineIsoform(
  rel_orf,
  tran,
  isoform_names = c("perfect_match", "elong_START_match", "trunc_START_match",
    "elong_STOP_match", "trunc_STOP_match", "overlap_inside", "overlap_both",
    "overlap_upstream", "overlap_downstream", "upstream", "downstram", "none")
)
}
\arguments{
\item{rel_orf}{- GRanges object of your ORF.}

\item{tran}{- GRanges object of annotation (transcript or cds) that
overlapped in some way rel_orf.}

\item{isoform_names}{- A vector of strings that will be used instead of
these defaults:
'perfect_match' - start and stop matches the tran object strand wise
'elong_START_match' - rel_orf is extension from the STOP side of the tran
'trunc_START_match' - rel_orf is truncation from the STOP side of the tran
'elong_STOP_match' - rel_orf is extension from the START side of the tran
'trunc_STOP_match' - rel_orf is truncation from the START side of the tran
'overlap_inside' - rel_orf is inside tran object
'overlap_both' - rel_orf contains tran object inside
'overlap_upstream' - rel_orf is overlaping upstream part of the tran
'overlap_downstream' - rel_orf is overlaping downstream part of the tran
'upstream' - rel_orf is upstream towards the tran
'downstream' - rel_orf is downstream towards the tran
'none' - when none of the above options is true}
}
\value{
A string object of defined isoform towards transcript.
}
\description{
Overlaps GRanges object with provided annotations.
}
\keyword{internal}
