% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_usage.R
\name{codon_usage_plot}
\alias{codon_usage_plot}
\title{Plot codon_usage}
\usage{
codon_usage_plot(
  res,
  score_column = res$relative_to_max_score,
  ylab = "Ribo-seq library",
  legend.position = "none",
  limit = c(0, max(score_column)),
  midpoint = max(limit/2),
  monospace_font = TRUE,
  ignore_start_stop_codons = FALSE
)
}
\arguments{
\item{res}{a data.table of output from a codon_usage function}

\item{score_column}{numeric, default: res$relative_to_max_score.
Which parameter to use as score column.}

\item{ylab}{character vector, names for libraries to show on Y axis}

\item{legend.position}{character, default "none", do not display legend.}

\item{limit}{numeric, 2 values for plot color limits. Default:
c(0, max(score_column))}

\item{midpoint}{numeric, default: max(limit / 2). midpoint of color limit.}

\item{monospace_font}{logical, default TRUE. Use monospace font, this
does not work on systems (require specific font packages), set to
FALSE if it crashes for you.}

\item{ignore_start_stop_codons}{logical, default FALSE. If TRUE, remove start (#)
and stop (*) codons.}
}
\value{
a ggplot object
}
\description{
Plot codon_usage
}
\examples{
df <- ORFik.template.experiment()[9:10,] # Subset to 2 Ribo-seq libs
## For multiple libs
res2 <- codon_usage_exp(df, outputLibs(df, type = "pshifted", output.mode = "list"),
                 min_counts_cds_filter = 10)
# codon_usage_plot(res2, monospace_font = TRUE) # This gives check error
codon_usage_plot(res2, monospace_font = FALSE) # monospace font looks better
}
\seealso{
Other codon: 
\code{\link{codon_usage}()},
\code{\link{codon_usage_exp}()}
}
\concept{codon}
