% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_plots.R
\name{savePlot}
\alias{savePlot}
\title{Helper function for writing plots to disc}
\usage{
savePlot(
  plot,
  output = NULL,
  width = 200,
  height = 150,
  plot.ext = ".pdf",
  dpi = 300,
  limitsize = FALSE
)
}
\arguments{
\item{plot}{the ggplot to save}

\item{output}{character string (NULL), if set, saves the plot as pdf or png
to path given. If no format is given,
is save as specified by plot.ext argument.}

\item{width}{width of output in mm}

\item{height}{height of output in mm}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".}

\item{dpi}{(300) dpi of plot}

\item{limitsize}{logical, default FALSE. If TRUE, activate ggplot max size restriction.}
}
\value{
a ggplot object of the coverage plot, NULL if output is set,
then the plot will only be saved to location.
}
\description{
Helper function for writing plots to disc
}
\seealso{
Other coveragePlot: 
\code{\link{coverageHeatMap}()},
\code{\link{pSitePlot}()},
\code{\link{windowCoveragePlot}()}
}
\concept{coveragePlot}
\keyword{internal}
