% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riboseq_features.R
\name{entropy}
\alias{entropy}
\title{Percentage of maximum entropy}
\usage{
entropy(grl, reads, weight = 1L, is.sorted = FALSE, overlapGrl = NULL)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} object
can be either transcripts, 5' utrs, cds', 3' utrs or
ORFs as a special case (uORFs, potential new cds' etc). If
regions are not spliced you can send a \code{\link{GRanges}} object.}

\item{reads}{a \code{\link{GAlignments}}, \code{\link{GRanges}} or
\code{\link{GRangesList}} object, usually of RiboSeq, RnaSeq, CageSeq, etc.}

\item{weight}{a numeric/integer vector or metacolumn name.
(default: 1L, no differential weighting).
If weight is name of defined meta column in reads object,
it gives the number of times a read was found at that position.
GRanges("chr1", 1, "+", score = 5), would mean "score" column tells
that this alignment region was found 5 times.
if 1L it means each read is weighted equal as 1,
this is what among others countOverlaps() presumes,
if single number (!= 1), it repeats for all ranges,
if vector with length > 1, it must be equal size of the
reads object.}

\item{is.sorted}{logical (FALSE), is grl sorted. That is + strand groups in
increasing ranges (1,2,3), and - strand groups in decreasing ranges (3,2,1)}

\item{overlapGrl}{an integer, (default: NULL),
if defined must be countOverlaps(grl, RFP),
added for speed if you already have it.}
}
\value{
A numeric vector containing one entropy value per element in
`grl`
}
\description{
Calculates percentage of maximum entropy of the `reads`
coverage over each ORF in `grl` group.
The entropy value per group is a real number in the interval (0:1),
where 0 indicates no variance in reads over all codons of group
For example c(0,0,0,0) has 0 entropy, since no reads overlap.\cr
Interval: [0]: No reads or all reads in 1 place \cr
Interval: [0.01-0.99]: >= 2 positions covered \cr
Interval: [1]: all positions covered perfectly in frame\cr
}
\examples{
# a toy example with ribo-seq p-shifted reads
ORF <- GRangesList(tx1 = GRanges("1", IRanges(1, width = 9), "+"))
entropy(ORF, GRanges()) # 0
entropy(ORF, GRanges("1", IRanges(c(1)), "+")) # 0
entropy(ORF, GRanges("1", IRanges(c(1,4,6,7)), "+")) # 0.94
entropy(ORF, GRanges("1", IRanges(c(1,4,7)), "+", score = c(1,2,1)),
        weight = "score") # 0.94
entropy(ORF, GRanges("1", IRanges(c(1,4,7)), "+")) # Perfect = 1
}
\seealso{
Other features: 
\code{\link{computeFeatures}()},
\code{\link{computeFeaturesCage}()},
\code{\link{countOverlapsW}()},
\code{\link{disengagementScore}()},
\code{\link{distToCds}()},
\code{\link{distToTSS}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fpkm_calc}()},
\code{\link{fractionLength}()},
\code{\link{initiationScore}()},
\code{\link{insideOutsideORF}()},
\code{\link{isInFrame}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeReleaseScore}()},
\code{\link{ribosomeStallingScore}()},
\code{\link{startRegion}()},
\code{\link{startRegionCoverage}()},
\code{\link{stopRegion}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
