% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateORFs.r
\name{annotateORFs}
\alias{annotateORFs}
\title{Annotate open reading frames}
\usage{
annotateORFs(orfs, tr, gtf = NULL, prts, workDir = NULL)
}
\arguments{
\item{orfs}{character string giving the name of tab-delimited TXT file with
coordinates of open reading frame(-s). This file should include three
mandatory fields:
i) transcript_id - transcript ID;
ii) start        - start coordinate of open reading frame
                   in a transcript;
iii) end         - end coordinate of open reading frame in a transcript.}

\item{tr}{character string giving the name of file with transcript(-s)
of interest. This file must include the transcript(-s) for which the
open reading frame(-s) was/were identified and listed in above orfs
file. Valid format is "fasta" or "fa".}

\item{gtf}{character string giving the name of GTF/GFF file with annotated
transcripts of interest. Default value is NULL.}

\item{prts}{character string giving the name of FASTA file with sequences of
in silico translated proteins encoded by identified open reading frames.}

\item{workDir}{character string giving the path to and name of work
directory. NULL by default that mean the current working directory.}
}
\value{
data.frame object with columns:
 \item{transcript_id}{transcript ID.}
 \item{f_utr.length}{length of 5'UTRs.}
 \item{start.codon}{type of start codon.}
 \item{orf.start}{start coordinate of open reading frames.}
 \item{orf.stop}{stop coordinate of open reading frames.}
 \item{stop.codon}{type of stop codon.}
 \item{stop.status}{PTC status of stop codon.}
 \item{orf.length}{length of open reading frames.}
 \item{t_utr.length}{length of 3'UTRs.}
 \item{MW}{molecular weight.}
 \item{pI}{isoelectic point of a protein sequence.}
 \item{indexPPI}{potential protein interaction index.}
}
\description{
Annotate the open reading frames identified in nucleotide
    sequences of interest.
}
\examples{
orfs_path <- system.file("extdata",
                         "Set.trans_ORFs.coordinates.txt",
                         package="ORFhunteR")
tr_path <- system.file("extdata",
                       "Set.trans_sequences.fasta",
                       package="ORFhunteR")
gtf_path <- system.file("extdata",
                        "Set.trans_sequences.gtf",
                        package="ORFhunteR")
prts_path <- system.file("extdata",
                         "Set.trans_proteins.sequences.fasta",
                         package="ORFhunteR")
anno_orfs <- annotateORFs(orfs=orfs_path,
                          tr=tr_path,
                          gtf=gtf_path,
                          prts=prts_path,
                          workDir=NULL)
}
\author{
Vasily V. Grinev
}
