 \name{fdr.int}
\alias{fdr.int} 
\title{Assessment of the significance of  intensity-dependent bias}	
\description{This function assesses the significance of intensity-dependent bias by an one-sided random permutation test.  The observed average values of logged fold-changes within an intensity neighbourhood are compared to an empirical distribution generated by random  permutation. The significance  is given by the false discovery rate.}
\usage{fdr.int(A,M,delta=50,N=100,av="median")}
\arguments{\item{A}{vector of average logged spot intensity}
           \item{M}{vector of logged fold changes}
           \item{delta}{integer determining the size of the neighbourhood. The actual window size is 
            (\code{2 * delta+1}).}
           \item{N}{number of random permutations performed for generation of empirical distribution}
           \item{av}{averaging of \code{M} within neighbourhood by \emph{mean} or \emph{median} (default)}
          }
\details{The function \code{fdr.int} assesses significance of  intensity-dependent bias using a one-sided random permutation test.
           The null hypothesis states the independence of A and M. To test if \code{M} depends on \code{A}, 
           spots are ordered with respect to A. This defines a neighbourhood of spots with similar A for each spot. 
           Next, a test statistic is defined by calculating the \emph{median} or \emph{mean} of \code{M}
            within
           a symmetrical spot's intensity neighbourhood of chosen size (\code{2 *delta+1}). An empirical distribution of the 
           test statistic is produced by calculating  for \code{N} random  intensity orders of spots. 
           Comparing this empirical distribution of \eqn{\bar{M}}{median/mean of \code{M}}
            with the observed distribution of \eqn{\bar{M}}{median/mean of \code{M}},
            the independence of \code{M} and \code{A}
           is assessed. If \code{M} is independent of \code{A}, the empirical distribution 
           of \eqn{\bar{M}}{median/mean of \code{M}} can be  expected to be  
            distributed around its mean value.  The false discovery rate (\emph{FDR}) is used to  
          assess the significance of observing positive deviations of  \eqn{\bar{M}}{median/mean of \code{M}}. 
          It  indicates the expected proportion of false positives 
          among  rejected null hypotheses. It is defined as \eqn{FDR=q\ast T/s}{FDR=q*T/s}, 
          where \emph{q} is the fraction of \eqn{\bar{M}}{median/mean of \code{M}} larger than  chosen threshold  \emph{c}
         for the empirical distribution, \code{s} is the number of neighbourhoods with  
          \eqn{\bar{M}>c}{(median/mean of \code{M})> c} 
           for the distribution derived from the original data and \code{T} 
           is the total number of neighbourhoods in the original data. 
          Varying threshold \emph{c} determines the FDR for each spot neighbourhood. FDRs equal zero are set to
          \eqn{FDR=1/T\ast N}{FDR=1/T*N} for computational reasons, as \code{log10(FDR)} is plotted by \code{sigint.plot}.
         Correspondingly, the significance
          of observing negative deviations of \eqn{\bar{M}}{median/mean of \code{M}} can be determined. If the neighbourhood
         window extends over the limits of the intensity scale, the significance is set to \code{NA}.}
\value{A list of vector containing the false discovery rates for positive  (\code{FDRp}) and negative (\code{FDRn})  deviations of
       \eqn{\bar{M}}{median/mean of \code{M}} (of the spot's neighbourhood) is produced. }
\note{The same functionality but with our input and output formats is offered by \code{\link{fdr.int}}}
\author{Matthias E. Futschik (\url{http://itb.biologie.hu-berlin.de/~futschik})}
\seealso{\code{\link{fdr.int2}},\code{\link{p.int}}, \code{\link{fdr.spatial}}, \code{\link{sigint.plot}}}
\examples{

# To run these examples, delete the comment signs (#) in front of the commands.
#
# LOADING DATA NOT-NORMALISED
# data(sw)
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS
# For this example, N was chosen rather small. For "real" analysis, it should be larger.
# FDR <- fdr.int(maA(sw)[,1],maM(sw)[,1],delta=50,N=10,av="median")
# VISUALISATION OF RESULTS
# sigint.plot(maA(sw)[,1],maM(sw)[,1],FDR$FDRp,FDR$FDRn,c(-5,-5))

# LOADING NORMALISED DATA
# data(sw.olin)
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS 
# FDR <- fdr.int(maA(sw.olin)[,1],maM(sw.olin)[,1],delta=50,N=10,av="median")
# VISUALISATION OF RESULTS
# sigint.plot(maA(sw.olin)[,1],maM(sw.olin)[,1],FDR$FDRp,FDR$FDRn,c(-5,-5))

}
\keyword{nonparametric}
\keyword{univar}
\keyword{htest}




