% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summarizeOverlap}
\alias{summarizeOverlap}
\title{Calculates min/max/average overlap}
\usage{
summarizeOverlap(OGREDataSet)
}
\arguments{
\item{OGREDataSet}{An OGREDataSet}
}
\value{
OGREDataSet.
}
\description{
Calculates min/max/average overlap for all datasets using \code{summary()}.
Results can be accessed by \code{metadata(OGREDataSet)$summaryDT} which is a
\code{list()} of two \code{data.table} objects. The first one includes
elements without any overlap at all and the second provides summary numbers
for all elements that have at least one overlap.
}
\examples{
myOGRE <- makeExampleOGREDataSet()
myOGRE <- loadAnnotations(myOGRE)
myOGRE <- fOverlaps(myOGRE)
myOGRE <- summarizeOverlap(myOGRE)
metadata(myOGRE)$summaryDT
}
