% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{loadAnnotations}
\alias{loadAnnotations}
\title{Load annotation datasets}
\usage{
loadAnnotations(OGREDataSet)
}
\arguments{
\item{OGREDataSet}{A OGREDataSet.}
}
\value{
A OGREDataSet.
}
\description{
Load dataset files containing genomic regions annotation information from
hard drive. \code{loadAnnotations} calls \code{readQuery} and \code{readSubject}
to read in genomic regions as \code{GenomicRanges} objects stored as .RDS / .rds
files. Each region needs chromosome, start, end and strand information.
A unique ID and a name column must be present in the \code{GenomicRanges} object
metadata. OGRE searches for the query file in your query folder and any
number of subject files in your subjects folder. Alternatively, .gff (v2&v3) files
in the query or subject folder with attribute columns containing "ID" and "name"
information are read in by OGRE.
}
\examples{
myOGRE <- makeExampleOGREDataSet()
myOGRE <- loadAnnotations(myOGRE)
}
