% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputVerification.R
\name{setupRawDataObject}
\alias{setupRawDataObject}
\title{Prepare SummarizedExperiment object for raw data to be normalized containing 
data, design and annotation information}
\usage{
setupRawDataObject(
  dataPath,
  designPath,
  inputFormat = "default",
  zeroToNA = FALSE,
  sampleColName = "sample",
  groupColName = "group"
)
}
\arguments{
\item{dataPath}{File path to data matrix.}

\item{designPath}{File path to design matrix.}

\item{inputFormat}{Type of matrix for data, can be either 'default',
'proteios', 'maxquantprot' or 'maxquantpep'}

\item{zeroToNA}{If TRUE zeroes in the data is automatically converted to
NA values}

\item{sampleColName}{Column name for column containing sample names}

\item{groupColName}{Column name for column containing condition levels}
}
\value{
experimentObj SummarizedExperiment object loaded with the data
}
\description{
Prepare SummarizedExperiment object for raw data to be normalized containing 
data, design and annotation information
}
\examples{
data_path <- system.file(package="NormalyzerDE", "extdata", "tiny_data.tsv")
design_path <- system.file(package="NormalyzerDE", "extdata", "tiny_design.tsv")
df <- setupRawDataObject(data_path, design_path)
}
