% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{getReactomeDiagram}
\alias{getReactomeDiagram}
\title{Display the enriched Reactome diagram of the given Reactome pathway id.
This function is specific to only one pathway id and identifies the 
enriched genes in the diagram.}
\usage{
getReactomeDiagram(mrnaObject, pathway, imageFormat)
}
\arguments{
\item{mrnaObject}{Output of enrichment results}

\item{pathway}{Reactome pathway term}

\item{imageFormat}{Image format of the diagram. Possible image formats are
'png', 'svg'}
}
\value{
Shows reactome diagram marked with an enriched genes in a browser
}
\description{
Display the enriched Reactome diagram of the given Reactome pathway id.
This function is specific to only one pathway id and identifies the 
enriched genes in the diagram.
}
\examples{
\dontrun{
br_enr<-reactomeEnrichment(genes = breastmRNA,org_assembly='hg19')

getReactomeDiagram(mrnaObject = br_enr,pathway = br_enr@ID[1],
                   imageFormat = 'png')
                   }

}
