% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathRank.R
\name{extractPathNetwork}
\alias{extractPathNetwork}
\title{Creates a subnetwork from a ranked path list}
\usage{
extractPathNetwork(paths, graph)
}
\arguments{
\item{paths}{The paths extracted by \code{\link{pathRanker}}.}

\item{graph}{A annotated igraph object.}
}
\value{
A subnetwork from all paths provided. If paths are computed for several
labels (sample categories), a subnetwork is returned for each label.
}
\description{
Creates a subnetwork from a ranked path list generated by \code{\link{pathRanker}}.
}
\examples{
	## Prepare a weighted reaction network.
	## Conver a metabolic network to a reaction network.
 data(ex_sbml) # bipartite metabolic network of Carbohydrate metabolism.
 rgraph <- makeReactionNetwork(ex_sbml, simplify=TRUE)

	## Assign edge weights based on Affymetrix attributes and microarray dataset.
 # Calculate Pearson's correlation.
	data(ex_microarray)	# Part of ALL dataset.
	rgraph <- assignEdgeWeights(microarray = ex_microarray, graph = rgraph,
		weight.method = "cor", use.attr="miriam.uniprot",
		y=factor(colnames(ex_microarray)), bootstrap = FALSE)

	## Get ranked paths using probabilistic shortest paths.
 ranked.p <- pathRanker(rgraph, method="prob.shortest.path",
					K=20, minPathSize=6)

	## Get the subnetwork of paths in reaction graph.
	reaction.sub <- getPathsAsEIDs(ranked.p, rgraph)

	## Get the subnetwork of paths in the original metabolic graph.
	metabolic.sub <- getPathsAsEIDs(ranked.p, ex_sbml)

}
\seealso{
Other Path ranking methods: 
\code{\link{getPathsAsEIDs}()},
\code{\link{pathRanker}()}
}
\author{
Ahmed Mohamed
}
\concept{Path ranking methods}
