% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgseaPostprocessingXLSX.R
\name{fgseaPostprocessingXLSX}
\alias{fgseaPostprocessingXLSX}
\title{Postprocessing for GSEA analyses for Excel}
\usage{
fgseaPostprocessingXLSX(
  genesetResults,
  leadingEdge,
  limmaResults,
  join.threshold = 0.5,
  ngroups = NULL,
  dist.method = "binary",
  filename
)
}
\arguments{
\item{genesetResults}{Results from pathway analysis using limmaToFGSEA.}

\item{leadingEdge}{Results from fgseaToLEdge}

\item{limmaResults}{Results from runLimmaAnalysis}

\item{join.threshold}{The threshold distance to join gene sets. Gene sets 
with a distance below this value will be joined to a single "cluster."}

\item{ngroups}{The desired number of gene set groups. Either 
'join.threshold' or 'ngroups' must be specified, 'ngroups' takes priority 
if both are specified.}

\item{dist.method}{Method for distance calculation (see options for dist()).
We recommend the 'binary' (also known as Jaccard) distance.}

\item{filename}{File name for the output Excel file.}
}
\value{
An Excel file where the first sheet summarizes the gene set analysis 
results. Subsequent sheets are reports showing differential expression 
statistics of leading edge genes.
}
\description{
Clusters GSEA results by leading edge genes, and writes reports showing
gene expression profiles of these genes (to Excel).
}
\examples{
data("ExamplePathways")
data("ExampleResults") # Results from runLimmaAnalysis

fgseaResults <- limmaToFGSEA(ExampleResults, gene.sets = ExamplePathways)

leadingEdge <- fgseaToLEdge(fgseaResults, cutoff.type = "padj", cutoff = 0.1)

\donttest{
fgseaPostprocessingXLSX(fgseaResults, leadingEdge, 
                    limmaResults = ExampleResults,
                    join.threshold = 0.5,
                    filename = "Results.xlsx")
}
}
