% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modbam_to_tabix.R
\name{modbam_to_tabix}
\alias{modbam_to_tabix}
\title{Convert BAM with modifications to tabix format}
\usage{
modbam_to_tabix(x, out_file, mod_code = NanoMethViz::mod_code(x))
}
\arguments{
\item{x}{the \code{ModBamResult} object.}

\item{out_file}{the path of the output tabix.}

\item{mod_code}{the modification code to use, defaults to 'm' for 5mC
methylation.}
}
\value{
invisibly returns the name of the created tabix file.
}
\description{
The \code{modbam_to_tabix} function takes a ModBamResult object and
converts it into a tabix file format, which is efficient for indexing and
querying large datasets.
}
\details{
The possible tags for mod_code can be found at
\url{https://samtools.github.io/hts-specs/SAMtags.pdf} under the
'Base modifications' section.
}
\examples{
out_file <- paste0(tempfile(), ".tsv.bgz")
mbr <- ModBamResult(
    methy = ModBamFiles(
        samples = "sample1",
        paths = system.file("peg3.bam", package = "NanoMethViz",
        mustWork = FALSE)
    ),
    samples = data.frame(
        sample = "sample1",
        group = "group1"
    )
)

modbam_to_tabix(mbr, out_file)

}
