% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tabix_file.R
\name{create_tabix_file}
\alias{create_tabix_file}
\title{Create a tabix file using methylation calls}
\usage{
create_tabix_file(
  input_files,
  output_file,
  samples = extract_file_names(input_files),
  verbose = TRUE
)
}
\arguments{
\item{input_files}{the files to convert}

\item{output_file}{the output file to write results to (must end in .bgz)}

\item{samples}{the names of samples corresponding to each file}

\item{verbose}{TRUE if progress messages are to be printed}
}
\value{
invisibly returns the output file path, creates a tabix file (.bgz)
and its index (.bgz.tbi)
}
\description{
Create a tabix file using methylation calls
}
\examples{
methy_calls <- system.file(package = "NanoMethViz",
    c("sample1_nanopolish.tsv.gz", "sample2_nanopolish.tsv.gz"), mustWork = FALSE)
temp_file <- paste0(tempfile(), ".tsv.bgz")

create_tabix_file(methy_calls, temp_file)
}
