% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModBamResults.R
\docType{class}
\name{ModBamResult-class}
\alias{ModBamResult-class}
\alias{methy,ModBamResult-method}
\alias{methy<-,ModBamResult,ModBamFiles-method}
\alias{samples,ModBamResult-method}
\alias{samples<-,ModBamResult,data.frame-method}
\alias{exons,ModBamResult-method}
\alias{exons<-,ModBamResult,data.frame-method}
\alias{mod_code,ModBamResult-method}
\alias{mod_code<-,ModBamResult,character-method}
\alias{ModBamResult}
\title{Modbam methylation results}
\usage{
\S4method{methy}{ModBamResult}(object)

\S4method{methy}{ModBamResult,ModBamFiles}(object) <- value

\S4method{samples}{ModBamResult}(object)

\S4method{samples}{ModBamResult,data.frame}(object) <- value

\S4method{exons}{ModBamResult}(object)

\S4method{exons}{ModBamResult,data.frame}(object) <- value

\S4method{mod_code}{ModBamResult}(object)

\S4method{mod_code}{ModBamResult,character}(object) <- value

ModBamResult(methy, samples, exons = NULL, mod_code = "m")
}
\arguments{
\item{object}{the ModBamResult object.}

\item{value}{the mod code.}

\item{methy}{a ModBamFiles object.}

\item{samples}{the data.frame of sample annotation containing at least
columns sample and group.}

\item{exons}{(optional) the data.frame of exon information containing at
least columns gene_id, chr, strand, start, end, transcript_id and symbol.}

\item{mod_code}{a character with the mod code of interest. Defaults to "m"
for 5mC. See details for other options.}
}
\value{
a NanoMethResult object to be used with plotting functions

a ModBamFiles data.frame.

the sample annotation.

the exon annotation.

the mod code.
}
\description{
A ModBamResult object stores modbam data used for NanoMethViz
visualisation. It contains stores a ModBamFiles object, sample information
and optional exon information. The object is constructed using the
ModBamResult() constructor function described in "Usage".
}
\details{
The possible tags for mod_code can be found at
\url{https://samtools.github.io/hts-specs/SAMtags.pdf} under the
'Base modifications' section.
}
\section{Functions}{
\itemize{
\item \code{methy(ModBamResult)}: modbam information getter.

\item \code{methy(object = ModBamResult) <- value}: modbam information setter.

\item \code{samples(ModBamResult)}: sample annotation getter.

\item \code{samples(object = ModBamResult) <- value}: sample annotation setter.

\item \code{exons(ModBamResult)}: exon annotation getter.

\item \code{exons(object = ModBamResult) <- value}: exon annotation setter.

\item \code{mod_code(ModBamResult)}: mod code getter.

\item \code{mod_code(object = ModBamResult) <- value}: mod code setter.

\item \code{ModBamResult()}: Constructor

}}
\section{Slots}{

\describe{
\item{\code{methy}}{a ModBamFiles data.frame specifying the samples and paths to bam
files.}

\item{\code{samples}}{the data.frame of sample annotation containing at least columns
sample and group.}

\item{\code{exons}}{the data.frame of exon information containing at least columns
gene_id, chr, strand, start, end, transcript_id and symbol.}

\item{\code{mod_code}}{the modification code of interest.}
}}

