% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lengthen_mut_matrix.R
\name{lengthen_mut_matrix}
\alias{lengthen_mut_matrix}
\title{A mutation_matrix calculated on a GRangesList or GR object modified by 'split_muts_region()',
will contain a column per combination of sample and genomic region. In essence different regions
are treated as different samples. This function will transform the matrix, so that these regions
are instead treated as different mutation types. For example, instead of 'C[C>T]G', you might have
the feature 'C[C>T]G Promoter'. The number of rows in the matrix will thus be
multiplied by the number of regions.
After using 'split_muts_region()', use 'mut_matrix()' to get a mut_matrix that can be used
for this function.
The result can be plotted with plot_profile_region, but could also be used for NMF, refitting ect.}
\usage{
lengthen_mut_matrix(mut_matrix)
}
\arguments{
\item{mut_matrix}{Mutation matrix}
}
\value{
mut_matrix
}
\description{
A mutation_matrix calculated on a GRangesList or GR object modified by 'split_muts_region()',
will contain a column per combination of sample and genomic region. In essence different regions
are treated as different samples. This function will transform the matrix, so that these regions
are instead treated as different mutation types. For example, instead of 'C[C>T]G', you might have
the feature 'C[C>T]G Promoter'. The number of rows in the matrix will thus be
multiplied by the number of regions.
After using 'split_muts_region()', use 'mut_matrix()' to get a mut_matrix that can be used
for this function.
The result can be plotted with plot_profile_region, but could also be used for NMF, refitting ect.
}
\examples{

## See the 'split_muts_region()' and 'mut_matrix()' examples for how we obtained the
## mutation matrix information:
mut_mat_split_region <- readRDS(system.file("states/mut_mat_data.rds",
  package = "MutationalPatterns"
))

long_mut_mat <- lengthen_mut_matrix(mut_mat_split_region)


## This also works on indels:
## See the 'split_muts_region()' and 'count_indels_context()' examples for how we
## obtained the indel counts:
indel_counts_split <- readRDS(system.file("states/blood_indels_counts_split_region.rds",
  package = "MutationalPatterns"
))


## Lengthen the matrix
lengthen_mut_matrix(indel_counts_split)
}
\seealso{
Other genomic_regions: 
\code{\link{bin_mutation_density}()},
\code{\link{plot_profile_region}()},
\code{\link{plot_spectrum_region}()},
\code{\link{split_muts_region}()}
}
\concept{genomic_regions}
